<?php

namespace App\Http\Controllers\Stats;

use Carbon\Carbon;
use App\Models\History;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\EmployeManagement\Employe;
use App\Services\Constants\HistoryAction;

class EmployeStatsController extends Controller
{
    /**
     * Nombre total d'employé
     * @unauthenticated
     */
    public function AllEmploye()
    {
        $countAllEmploye = Employe::active()->count();

        return response()->json([
            "message" => "Nombre total d'employé actif",
            "data" => $countAllEmploye
        ]);
    }

    /**
     * Nombre total d'employé en congé
     * @unauthenticated
     */

    public function AllEmployeLeave()
    {
        $countAllEmployeLeave = Employe::leave()->count();

        return response()->json([
            "message" => "Nombre total d'employé en congé",
            "data" => $countAllEmployeLeave
        ]);
    }

    /**
     * Retourne le nombre de contrats à renouveler dans les 30 prochains jours
     * @unauthenticated
     */
    public function contractsToRenew()
    {
        $today = Carbon::today();
        $limitDate = Carbon::today()->addDays(30);

        $count = Employe::whereNotNull('contract_end_date')
            ->whereBetween('contract_end_date', [$today, $limitDate])
            ->where('status', 'active') // optionnel mais souvent logique
            ->count();

        return response()->json([
            // 'from_date' => $today->toDateString(),
            // 'to_date' => $limitDate->toDateString(),
            'message' => 'Nombre total de contrats à renouveler',
            'data' => $count,
        ]);
    }

    /**
     * Nombre de présent aujourd'hui
     * @unauthenticated
     */

    public function todaysPresenceCount()
    {
        $today = Carbon::today();

        $count = History::whereDate('action_date', $today)
            ->where('action', HistoryAction::POINTAGE) // ou HistoryAction::POINTAGE
            ->where('share_value', HistoryAction::PRESENT)
            ->distinct('employe_id')
            ->count('employe_id');

        return response()->json([
            "message" => "Le nombre total d'employé présent aujourd'hui",
            "date" => $today->format('d/m/Y'),
            "present" => $count
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}