<?php

namespace App\Http\Requests\AccountMobileManagement;

use Illuminate\Foundation\Http\FormRequest;

class StoreMobileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'employe_id' => 'required|exists:employes,id',
            'account_number' => 'required|string|unique:money_accounts,account_number',
            // 'type' => 'required|string|in:internal,mobile_money,bank',
            'type' => 'required|string',
            'operator' => 'required|string|max:100',
            'currency' => 'required|string|in:XOF,USD,EUR',
        ];
    }

    /**
     * Messages 
     */

    public function messages(): array
    {
        return [
            'employe_id.required' => 'Veuillez sélectionner un employé.',
            'account_number.required' => 'Le numéro de compte est obligatoire.',
            'account_number.unique' => 'Ce numéro de compte existe déjà.',
            'operator.required' => "L'opérateur est obligatoire(OM,MTN,Wave,Moov)",
            //'type.in' => 'Le type de compte doit être interne, mobile_money ou bank.',
            'currency.in' => 'La devise doit être XOF, USD ou EUR.',
        ];
    }
}