<?php

namespace App\Http\Requests\PaymentManagement;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class RegisterValidationPaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [

            'employe_id' => 'required|exists:employes,id',
            'montant' => 'required|numeric|min:0',
            'tax_code' => 'required|string|max:50',
            'payment_date' => 'required|date',
            'payment_code' => 'required|string|unique:payments,payment_code',
            'status' => [
                'required',
                Rule::in(['en attente', 'validé', 'rejeté']), // Seules ces valeurs sont autorisées pour la validation
            ],
            'comments' => ['nullable', 'string', 'required_if:status,rejeté'], // optionnel, pour commentaire
        ];
    }

    /**
     * Messages
     */

    public function messages(): array
    {
        return [
            'employe_id.required' => "Veuillez sélectionner un employé.",
            'employe_id.exists' => "L'employé sélectionné n'existe pas.",
            'montant.required' => "Le montant du paiement est requis.",
            'montant.numeric' => "Le montant doit être un nombre.",
            'montant.min' => "Le montant doit être supérieur ou égal à 0.",
            'tax_code.required' => "Le code d'imposition est obligatoire.",
            'tax_code.string' => "Le code d'imposition doit être du texte.",
            'tax_code.max' => "Le code d'imposition ne doit pas dépasser 50 caractères.",
            'payment_date.required' => "La date du paiement est obligatoire.",
            'payment_date.date' => "La date du paiement doit être une date valide.",
            'payment_code.required' => "Le code de paiement est obligatoire.",
            'payment_code.string' => "Le code de paiement doit être du texte.",
            'payment_code.unique' => "Ce code de paiement existe déjà.",
            'status.required' => "Le statut du paiement est obligatoire pour la validation.",
            'status.in' => 'Le statut doit être soit "en attente", "validé", soit "rejeté".',
            'comments.required_if' => "Vous devez fournir un commentaire si le paiement est rejeté.",
            'comments.string' => "Le commentaire doit être du texte.",
        ];
    }
}