<?php

namespace App\Http\Requests\PaymentManagement;

use Illuminate\Foundation\Http\FormRequest;

class StorePaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'employe_id' => 'required|exists:employes,id',
            'montant' => 'required|numeric|min:0',
            'tax_code' => 'required|string|max:50',
            'payment_date' => 'required|date',
            'payment_code' => 'required|string|unique:payments,payment_code',
        ];
    }

    /**
     * Messages
     */

    public function messages(): array
    {
        return [
            'employe_id.required' => "Vous devez sélectionner un employé.",
            'employe_id.exists' => "L'employé sélectionné n'existe pas.",
            'montant.required' => "Le montant du paiement est requis.",
            'montant.numeric' => "Le montant doit être un nombre.",
            'montant.min' => "Le montant doit être supérieur ou égal à 0.",
            'tax_code.required' => "Le code d'imposition est requis.",
            'tax_code.string' => "Le code d'imposition doit être une chaîne de caractères.",
            'tax_code.max' => "Le code d'imposition ne doit pas dépasser 50 caractères.",
            'payment_date.required' => "La date de paiement est requise.",
            'payment_date.date' => "La date de paiement doit être de type date.",
            'payment_code.required' => "Le code de paiement est requis.",
            'payment_code.string' => "Le code de paiement doit être une chaîne de caractères.",
            'payment_code.unique' => "Ce code de paiement existe déjà.",
        ];
    }
}