<?php

namespace App\Http\Requests\PaymentManagement;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ValidationPaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'status' => [
                'required',
                Rule::in(['validé', 'rejeté']), // Seules ces valeurs sont autorisées pour la validation
            ],
            'comments' => ['nullable', 'string', 'required_if:status,rejeté',], // optionnel, pour commentaire
        ];
    }

    /**
     * Messages
     */

    public function messages(): array
    {
        return [
            'status.required' => 'Le statut est obligatoire pour valider le paiement.',
            'status.in' => 'Le statut doit être "validé" ou "rejeté".',
            'comments.required_if' => "L'ajout d'un commentaire est obligatoire.",

        ];
    }
}